unit Service1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type TQItem = class(TObject)
 private
   fPNext  : pointer;  //    
   fData   : integer;  //   
 protected
   procedure SetPNextToOBJ(RqPNext : pointer);
   procedure SetDataToOBJ(RqData : integer);
   function  GetPNextFromOBJ() : pointer;
   function  GetDataFromOBJ() : integer;
end;

type TIQueue = class(TQItem)
 private
   fPHead   : TQItem;      //    
   fPTail   : TQItem;      //    
   fICount  : integer;     //    
   fPBuf    : TQItem;      //    
   fDisplay : TComponent;  //    
 public
   constructor Create(RqDisplay : TComponent);
   procedure Free();
   procedure DeleteItemFromHead();
   procedure AddItemToTail(RqData : integer);
   procedure ShowItemQueue(); virtual;
end;

type TDisplay = class(TIQueue)
 public
   procedure ShowItemQueue(); override;
end;

implementation

const MaxCount = 30;          //   

// -----------------------------------------------------------------------
//   TQItem
// -----------------------------------------------------------------------
procedure TQItem.SetPNextToOBJ(RqPNext : pointer);
begin fPNext := RqPNext; end;

procedure TQItem.SetDataToOBJ(RqData : integer);
begin fData := RqData; end;

function  TQItem.GetPNextFromOBJ() : pointer;
begin Result := fPNext; end;

function  TQItem.GetDataFromOBJ() : integer;
begin Result := fData; end;

// -----------------------------------------------------------------------
//     TIQueue
// -----------------------------------------------------------------------
// 
constructor TIQueue.Create (RqDisplay : TComponent);
begin
   inherited Create;
   fDisplay := RqDisplay;
end;

// 
procedure TIQueue.Free();
begin
  //   
  if (fICount > 0) and Assigned(fPHead) and Assigned(fPTail)
  then begin
     repeat
       fPBuf := fPHead;                     //    
       fPHead := fPHead.GetPNextFromOBJ();  //   
       fPBuf.Free;                          //  
     until not Assigned(fPHead);
  end;
  //   
  inherited Free;
end;

//         
procedure TIQueue.DeleteItemFromHead();
begin
 if (fICount > 0) and Assigned(fPHead)
 then begin
 //   
   fPBuf  := fPHead;                   //     
   fPHead := fPBuf.GetPNextFromOBJ();  //     
   fPBuf.Free;                         //  
   fICount := fICount - 1;             //    
   if not Assigned(fPHead)
   then begin
      //     
      fPTail    := nil;                //    
      fICount := 0;                    //    
   end;
 end;
end;

//      
procedure TIQueue.AddItemToTail(RqData : integer);
begin
   if Assigned(fPTail)                //    
   then begin
      //    (   )
      fPBuf  := fPTail;              //     
      fPTail := TQItem.Create;       //    
      fPBuf.SetPNextToOBJ(fPTail);   //     
      fICount := fICount + 1;        //   
   end
   else begin
      //   (    )
      fPTail := TQItem.Create;       //    
      fPTail.SetPNextToOBJ(nil);     //    
      fPHead  := fPTail;             //    
      fICount := 1;                  //    
   end;
   fPTail.SetDataToOBJ(RqData);      //    
   //          
   if (fICount > MaxCount)
   then DeleteItemFromHead();
end;

//    
procedure TIQueue.ShowItemQueue();
begin
  if (fDisplay is TMemo)
  then begin
    with fDisplay as TMemo do
    begin
       Clear;
      if (fICount > 0) and Assigned(fPHead) and Assigned(fPTail)
      then begin
         fPBuf := fPHead;
         repeat
            Lines.Add(IntToStr(fPBuf.GetDataFromOBJ));
            fPBuf := fPBuf.GetPNextFromOBJ();
         until not Assigned(fPBuf);
      end;
    end;
  end;
end;

// -----------------------------------------------------------------------
//     TDisplay
// -----------------------------------------------------------------------
//    
procedure TDisplay.ShowItemQueue();
var XStep        : integer;
    Count        : integer;
    YCurr, YNext : integer;
begin
  if (fDisplay is TImage)
  then begin
    with fDisplay as TImage do
    begin
      XStep := Width div MaxCount;
      Count := 0;
      //YNext := -1;
      // Clear
      Canvas.Brush.Style := bsSolid;
      Canvas.Brush.Color := clBlack;
      Canvas.FillRect(Rect(0,0,Width,Height));
      Canvas.Pen.Color := RGB(0,255,0);
      // Show

      if (fICount > 0) and Assigned(fPHead) and Assigned(fPTail)
      then begin
         fPBuf := fPHead;
         repeat
            YCurr := Height - fPBuf.GetDataFromOBJ;
            Canvas.MoveTo(Count * XStep, YCurr);
            Count := Count + 1;
            Canvas.LineTo(Count * XStep, YCurr);
            
            fPBuf := fPBuf.GetPNextFromOBJ();

            if Assigned(fPBuf)
            then begin
              YNext := Height - fPBuf.GetDataFromOBJ;
              if YNext >=0 then Canvas.LineTo(Count * XStep, YNext);
            end;
         until not Assigned(fPBuf);
      end;
    end;
  end;
end;

end.
